#!/usr/bin/env python3

# -*- encoding: utf-8; py-indent-offset: 4 -*-

# (c) Michael Honkoop <mhonkoop@comsolve.nl>

# License: GNU General Public License v2

"""parameters for eDirectory monitor RecordManager"""

from cmk.rulesets.v1 import Title, Help
from cmk.rulesets.v1.form_specs import (
    DictElement,
    Dictionary,
    InputHint,
    Integer,
    LevelDirection,
    migrate_to_integer_simple_levels,
    SimpleLevels,
    String,
)

from cmk.rulesets.v1.rule_specs import (
    CheckParameters,
    Topic,
    HostAndItemCondition,
)

def _vaulespec_edirectory_monitor_recordmanager_cachestatisticscachefaultLooks() -> Dictionary:
    return Dictionary(
        title=Title("CacheStatistics CacheFaultLooks"),
        elements={
            "Cachefaultlooks_Blockcache": DictElement(
                required=False,
                parameter_form=SimpleLevels[int](
                    title=Title("Blockcache"),
                    level_direction=LevelDirection.UPPER,
                    form_spec_template=Integer(),
                    migrate=migrate_to_integer_simple_levels,
                    prefill_fixed_levels=InputHint(value=(0, 5)),
                )
            ),
            "Cachefaultlooks_Entrycache": DictElement(
                required=False,
                parameter_form=SimpleLevels[int](
                    title=Title("Entrycache"),
                    level_direction=LevelDirection.UPPER,
                    form_spec_template=Integer(),
                    migrate=migrate_to_integer_simple_levels,
                    prefill_fixed_levels=InputHint(value=(0, 5)),
                )
            ),
            "Cachefaultlooks_Total": DictElement(
                required=False,
                parameter_form=SimpleLevels[int](
                    title=Title("Total"),
                    level_direction=LevelDirection.UPPER,
                    form_spec_template=Integer(),
                    migrate=migrate_to_integer_simple_levels,
                    prefill_fixed_levels=InputHint(value=(0, 5)),
                )
            ),
        }
    )

def _vaulespec_edirectory_monitor_recordmanager_cachestatisticscachefaults() -> Dictionary:
    return Dictionary(
        title=Title("CacheStatistics CacheFaults"),
        elements={
            "Cachefaults_Blockcache": DictElement(
                required=False,
                parameter_form=SimpleLevels[int](
                    title=Title("Blockcache"),
                    level_direction=LevelDirection.UPPER,
                    form_spec_template=Integer(),
                    migrate=migrate_to_integer_simple_levels,
                    prefill_fixed_levels=InputHint(value=(0, 5)),
                )
            ),
            "Cachefaults_Entrycache": DictElement(
                required=False,
                parameter_form=SimpleLevels[int](
                    title=Title("Entrycache"),
                    level_direction=LevelDirection.UPPER,
                    form_spec_template=Integer(),
                    migrate=migrate_to_integer_simple_levels,
                    prefill_fixed_levels=InputHint(value=(0, 5)),
                )
            ),
            "Cachefaults_Total": DictElement(
                required=False,
                parameter_form=SimpleLevels[int](
                    title=Title("Total"),
                    level_direction=LevelDirection.UPPER,
                    form_spec_template=Integer(),
                    migrate=migrate_to_integer_simple_levels,
                    prefill_fixed_levels=InputHint(value=(0, 5)),
                )
            ),
        }
    )

def _vaulespec_edirectory_monitor_recordmanager_cachestatisticscurrentsize() -> Dictionary:
    return Dictionary(
        title=Title("CacheStatistics CurrentSize"),
        elements={
            "Currentsize_Blockcachesize": DictElement(
                required=False,
                parameter_form=SimpleLevels[int](
                    title=Title("Blockcache Size"),
                    level_direction=LevelDirection.UPPER,
                    form_spec_template=Integer(),
                    migrate=migrate_to_integer_simple_levels,
                    prefill_fixed_levels=InputHint(value=(0, 5)),
                )
            ),
            "Currentsize_Entrycachesize": DictElement(
                required=False,
                parameter_form=SimpleLevels[int](
                    title=Title("Entrycache Size"),
                    level_direction=LevelDirection.UPPER,
                    form_spec_template=Integer(),
                    migrate=migrate_to_integer_simple_levels,
                    prefill_fixed_levels=InputHint(value=(0, 5)),
                )
            ),
            "Currentsize_Totalsize": DictElement(
                required=False,
                parameter_form=SimpleLevels[int](
                    title=Title("Totalsize"),
                    level_direction=LevelDirection.UPPER,
                    form_spec_template=Integer(),
                    migrate=migrate_to_integer_simple_levels,
                    prefill_fixed_levels=InputHint(value=(0, 5)),
                )
            ),
        }
    )

def _valuespec_edirectory_monitor_recordmanager() -> Dictionary:
    return Dictionary(
        title=Title("Recordmanager Service Parameters"),
        elements={
            "cachestatistics_cachefaultLooks": DictElement(
                parameter_form=_vaulespec_edirectory_monitor_recordmanager_cachestatisticscachefaultLooks(),
                required=False),
            "cachestatistics_cachefaults": DictElement(
                parameter_form=_vaulespec_edirectory_monitor_recordmanager_cachestatisticscachefaults(),
                required=False),
            "cachestatistics_currentsize": DictElement(
                parameter_form=_vaulespec_edirectory_monitor_recordmanager_cachestatisticscurrentsize(),
                required=False),
        },
    )

def _item_spec() -> String:
    return String(
        help_text=Help("ServiceName")
)

rule_spec_edirectory_monitor_recordmanager_params = CheckParameters(
    name="edirectory_monitor_recordmanager",
    title=Title("eDirectory Monitor Recordmanager Statistics"),
    topic=Topic.APPLICATIONS,
    condition=HostAndItemCondition(
        item_title=Title("ServiceName"), item_form=_item_spec()
    ),
    parameter_form=_valuespec_edirectory_monitor_recordmanager,
    create_enforced_service=False,
)
