#!/usr/bin/env python3

# -*- encoding: utf-8; py-indent-offset: 4 -*-

# (c) Michael Honkoop <mhonkoop@comsolve.nl>

# License: GNU General Public License v2

"""parameters for eDirectory monitor Dclient"""

from cmk.rulesets.v1 import Title, Help
from cmk.rulesets.v1.form_specs import (
    DictElement,
    Dictionary,
    InputHint,
    Integer,
    LevelDirection,
    migrate_to_integer_simple_levels,
    SimpleLevels,
    String,
)

from cmk.rulesets.v1.rule_specs import (
    CheckParameters,
    Topic,
    HostAndItemCondition,
)

def _vaulespec_edirectory_monitor_dclient_outboundconnection() -> Dictionary:
    return Dictionary(
        title=Title("Dclient Outbound Connection"),
        elements={
            "RefusedOutBoundConnection": DictElement(
                required=False,
                parameter_form=SimpleLevels[int](
                    title=Title("Refused OutBoundConnections"),
                    level_direction=LevelDirection.UPPER,
                    form_spec_template=Integer(),
                    migrate=migrate_to_integer_simple_levels,
                    prefill_fixed_levels=InputHint(value=(0, 5)),
                )
            ),
            "TotalOpenOutBoundConnection": DictElement(
                required=False,
                parameter_form=SimpleLevels[int](
                    title=Title("Total Open OutBound Connections"),
                    level_direction=LevelDirection.UPPER,
                    form_spec_template=Integer(),
                    migrate=migrate_to_integer_simple_levels,
                    prefill_fixed_levels=InputHint(value=(0, 5)),
                )
            ),
            "MaxOutBoundConnection": DictElement(
                required=False,
                parameter_form=SimpleLevels[int](
                    title=Title("Max OutBound Connections"),
                    level_direction=LevelDirection.UPPER,
                    form_spec_template=Integer(),
                    migrate=migrate_to_integer_simple_levels,
                    prefill_fixed_levels=InputHint(value=(0, 5)),
                )
            ),
        }
    )

def _vaulespec_edirectory_monitor_dclient_outboundcontext() -> Dictionary:
    return Dictionary(
        title=Title("Dclient Outbound Context"),
        elements={
            "ActiveOutBoundContextCount": DictElement(
                required=False,
                parameter_form=SimpleLevels[int](
                    title=Title("Active OutBound Context Count"),
                    level_direction=LevelDirection.UPPER,
                    form_spec_template=Integer(),
                    migrate=migrate_to_integer_simple_levels,
                    prefill_fixed_levels=InputHint(value=(0, 5)),
                )
            ),
            "TotalOutBoundContextCount": DictElement(
                required=False,
                parameter_form=SimpleLevels[int](
                    title=Title("Total OutBound Context Count"),
                    level_direction=LevelDirection.UPPER,
                    form_spec_template=Integer(),
                    migrate=migrate_to_integer_simple_levels,
                    prefill_fixed_levels=InputHint(value=(0, 5)),
                )
            ),
        }
    )

def _valuespec_edirectory_monitor_dclient() -> Dictionary:
    return Dictionary(
        title=Title("Dclient Service Parameters"),
        elements={
            "dclient_outboundconnection": DictElement(
                parameter_form=_vaulespec_edirectory_monitor_dclient_outboundconnection(),
                required=False),
            "dclient_outboundcontext": DictElement(
                parameter_form=_vaulespec_edirectory_monitor_dclient_outboundcontext(),
                required=False),
        },
    )

def _item_spec() -> String:
    return String(
        help_text=Help("ServiceName")
)

rule_spec_edirectory_monitor_dclient_params = CheckParameters(
    name="edirectory_monitor_dclient",
    title=Title("eDirectory Monitor Dclient Statistics"),
    topic=Topic.APPLICATIONS,
    condition=HostAndItemCondition(
        item_title=Title("ServiceName"), item_form=_item_spec()
    ),
    parameter_form=_valuespec_edirectory_monitor_dclient,
    create_enforced_service=False,
)
