#!/usr/bin/env python3

# -*- encoding: utf-8; py-indent-offset: 4 -*-

# (c) Michael Honkoop <mhonkoop@comsolve.nl>

# License: GNU General Public License v2

from cmk.rulesets.v1 import Help, Title
from cmk.rulesets.v1.form_specs import (
    DictElement,
    Dictionary,
    migrate_to_password,
    Password,
    String,
    validators,
)
from cmk.rulesets.v1.rule_specs import SpecialAgent, Topic

def _parameter_form() -> Dictionary:
    return Dictionary(
        help_text=Help(
            "This rule selects the Agent eDirectory Monitor instead of the normal Checkmk Agent "
            "which collects information through a LDAP call to cn=Monitor"
        ),
        elements={
            "user": DictElement(
                required=True,
                parameter_form=String(
                    title=Title("DN of Username for Monitoring"),
                    custom_validate=(validators.LengthInRange(min_value=1),),
                ),
            ),
            "password": DictElement(
                required=True,
                parameter_form=Password(
                    title=Title("Password of the User"),
                    custom_validate=(validators.LengthInRange(min_value=1),),
                    migrate=migrate_to_password,
                ),
            ),
        },
    )

rule_spec_special_agent_edirectory_monitor = SpecialAgent(
    name="edirectory_monitor",
    title=Title("eDirectory Monitoring via LDAP"),
    topic=Topic.APPLICATIONS,
    parameter_form=_parameter_form,
    )
