#!/usr/bin/env python3

# -*- encoding: utf-8; py-indent-offset: 4 -*-

# (c) Michael Honkoop <mhonkoop@comsolve.nl>

# License: GNU General Public License v2

"""parameters for eDirectory monitor"""

from cmk.rulesets.v1 import Title, Help
from cmk.rulesets.v1.form_specs import (
    DictElement,
    Dictionary,
    InputHint,
    Integer,
    LevelDirection,
    migrate_to_integer_simple_levels,
    SimpleLevels,
    String,
)

from cmk.rulesets.v1.rule_specs import (
    CheckParameters,
    Topic,
    HostAndItemCondition,
)

def _vaulespec_edirectory_monitor_ldap_bindings() -> Dictionary:
    return Dictionary(
        title=Title("LDAP Bindings"),
        elements={
            "bindSecurityErrors": DictElement(
                required=False,
                parameter_form=SimpleLevels[int](
                    title=Title("LDAP bind Security errors"),
                    level_direction=LevelDirection.UPPER,
                    form_spec_template=Integer(),
                    migrate=migrate_to_integer_simple_levels,
                    prefill_fixed_levels=InputHint(value=(0, 5)),
                )
            ),
            "strongAuthBinds": DictElement(
                required=False,
                parameter_form=SimpleLevels[int](
                    title=Title("LDAP Strong Auth Bindings"),
                    level_direction=LevelDirection.UPPER,
                    form_spec_template=Integer(),
                    migrate=migrate_to_integer_simple_levels,
                    prefill_fixed_levels=InputHint(value=(0, 5)),
                )
            ),
            "simpleAuthBinds": DictElement(
                required=False,
                parameter_form=SimpleLevels[int](
                    title=Title("LDAP Simple Authenticated Bindings"),
                    level_direction=LevelDirection.UPPER,
                    form_spec_template=Integer(),
                    migrate=migrate_to_integer_simple_levels,
                    prefill_fixed_levels=InputHint(value=(0, 5)),
                )
            ),
            "Bindings_unAuthBinds": DictElement(
                required=False,
                parameter_form=SimpleLevels[int](
                    title=Title("LDAP Unuthenticated Bindings"),
                    level_direction=LevelDirection.UPPER,
                    form_spec_template=Integer(),
                    migrate=migrate_to_integer_simple_levels,
                    prefill_fixed_levels=InputHint(value=(0, 5)),
                )
            ),
        }
    )

def _vaulespec_edirectory_monitor_ldap_errors() -> Dictionary:
    return Dictionary(
        title=Title("LDAP Errors"),
        elements={
            "securityErrors": DictElement(
                required=False,
                parameter_form=SimpleLevels[int](
                    title=Title("LDAP Security errors"),
                    level_direction=LevelDirection.UPPER,
                    form_spec_template=Integer(),
                    migrate=migrate_to_integer_simple_levels,
                    prefill_fixed_levels=InputHint(value=(0, 5)),
                )
            ),
            "errors": DictElement(
                required=False,
                parameter_form=SimpleLevels[int](
                    title=Title("LDAP errors"),
                    level_direction=LevelDirection.UPPER,
                    form_spec_template=Integer(),
                    migrate=migrate_to_integer_simple_levels,
                    prefill_fixed_levels=InputHint(value=(0, 5)),
                )
            ),
        }
    )

def _vaulespec_edirectory_monitor_ldap_incomingoperations() -> Dictionary:
    return Dictionary(
        title=Title("LDAP Incoming Operations"),
        elements={
            "extendedOps": DictElement(
                required=False,
                parameter_form=SimpleLevels[int](
                    title=Title("LDAP Extended Operations"),
                    level_direction=LevelDirection.UPPER,
                    form_spec_template=Integer(),
                    migrate=migrate_to_integer_simple_levels,
                    prefill_fixed_levels=InputHint(value=(0, 5)),
                )
            ),
            "abandonOps": DictElement(
                required=False,
                parameter_form=SimpleLevels[int](
                    title=Title("LDAP Abandoned Operations"),
                    level_direction=LevelDirection.UPPER,
                    form_spec_template=Integer(),
                    migrate=migrate_to_integer_simple_levels,
                    prefill_fixed_levels=InputHint(value=(0, 5)),
                )
            ),
            "wholeSubtreeSearchOps": DictElement(
                required=False,
                parameter_form=SimpleLevels[int](
                    title=Title("LDAP Whole Subtree Search Operations"),
                    level_direction=LevelDirection.UPPER,
                    form_spec_template=Integer(),
                    migrate=migrate_to_integer_simple_levels,
                    prefill_fixed_levels=InputHint(value=(0, 5)),
                )
            ),
            "oneLevelSearchOps": DictElement(
                required=False,
                parameter_form=SimpleLevels[int](
                    title=Title("LDAP One level Search Operations"),
                    level_direction=LevelDirection.UPPER,
                    form_spec_template=Integer(),
                    migrate=migrate_to_integer_simple_levels,
                    prefill_fixed_levels=InputHint(value=(0, 5)),
                )
            ),
            "searchOps": DictElement(
                required=False,
                parameter_form=SimpleLevels[int](
                    title=Title("LDAP all Search Operations"),
                    level_direction=LevelDirection.UPPER,
                    form_spec_template=Integer(),
                    migrate=migrate_to_integer_simple_levels,
                    prefill_fixed_levels=InputHint(value=(0, 5)),
                )
            ),
            "listOps": DictElement(
                required=False,
                parameter_form=SimpleLevels[int](
                    title=Title("LDAP list Operations"),
                    level_direction=LevelDirection.UPPER,
                    form_spec_template=Integer(),
                    migrate=migrate_to_integer_simple_levels,
                    prefill_fixed_levels=InputHint(value=(0, 5)),
                )
            ),
        }
    )

def _vaulespec_edirectory_monitor_ldap_trafficvolume() -> Dictionary:
    return Dictionary(
        title=Title("LDAP Traffic volume"),
        elements={
            "inBytes": DictElement(
                required=False,
                parameter_form=SimpleLevels[int](
                    title=Title("LDAP Traffic bytes in"),
                    level_direction=LevelDirection.UPPER,
                    form_spec_template=Integer(),
                    migrate=migrate_to_integer_simple_levels,
                    prefill_fixed_levels=InputHint(value=(0, 5)),
                )
            ),
            "outBytes": DictElement(
                required=False,
                parameter_form=SimpleLevels[int](
                    title=Title("LDAP Traffic bytes out"),
                    level_direction=LevelDirection.UPPER,
                    form_spec_template=Integer(),
                    migrate=migrate_to_integer_simple_levels,
                    prefill_fixed_levels=InputHint(value=(0, 5)),
                )
            ),
        }
    )

def _valuespec_edirectory_monitor_ldap() -> Dictionary:
    return Dictionary(
        title=Title("LDAP Service Parameters"),
        elements={
            "ldap_ldapstatistics_bindings": DictElement(
                parameter_form=_vaulespec_edirectory_monitor_ldap_bindings(),
                required=False),
            "ldap_errors": DictElement(
                parameter_form=_vaulespec_edirectory_monitor_ldap_errors(),
                required=False),
            "ldap_incomingoperations": DictElement(
                parameter_form=_vaulespec_edirectory_monitor_ldap_incomingoperations(),
                required=False),
            "ldap_trafficvolume": DictElement(
                parameter_form=_vaulespec_edirectory_monitor_ldap_trafficvolume(),
                required=False),
        },
    )

def _item_spec() -> String:
    return String(
        help_text=Help("ServiceName")
)

rule_spec_edirectory_monitor_ldap_params = CheckParameters(
    name="edirectory_monitor_ldap",
    title=Title("eDirectory Monitor LDAP Statistics"),
    topic=Topic.APPLICATIONS,
    condition=HostAndItemCondition(
        item_title=Title("ServiceName"), item_form=_item_spec()
    ),
    parameter_form=_valuespec_edirectory_monitor_ldap,
    create_enforced_service=False,
)
