#!/usr/bin/env python3

# -*- encoding: utf-8; py-indent-offset: 4 -*-

# (c) Michael Honkoop <mhonkoop@comsolve.nl>

# License: GNU General Public License v2

"""parameters for eDirectory monitor DHOST"""

from cmk.rulesets.v1 import Title, Help
from cmk.rulesets.v1.form_specs import (
    DictElement,
    Dictionary,
    InputHint,
    Integer,
    LevelDirection,
    migrate_to_integer_simple_levels,
    SimpleLevels,
    String,
    )

from cmk.rulesets.v1.rule_specs import (
    CheckParameters,
    Topic,
    HostAndItemCondition,
    )

def _vaulespec_edirectory_monitor_dhost_inboundconnections() -> Dictionary:
    return Dictionary(
        title=Title("DHOST Inbound Connections"),
        elements={
            "InBoundConnectionCount": DictElement(
                required=False,
                parameter_form=SimpleLevels[int](
                    title=Title("Inbound Connection Count"),
                    level_direction=LevelDirection.UPPER,
                    form_spec_template=Integer(),
                    migrate=migrate_to_integer_simple_levels,
                    prefill_fixed_levels=InputHint(value=(0, 5)),
                )
            ),
            "MaxInBoundConnection": DictElement(
                required=False,
                parameter_form=SimpleLevels[int](
                    title=Title("Max Inbound Connections"),
                    level_direction=LevelDirection.UPPER,
                    form_spec_template=Integer(),
                    migrate=migrate_to_integer_simple_levels,
                    prefill_fixed_levels=InputHint(value=(0, 5)),
                )
            ),
        }
    )

def _vaulespec_edirectory_monitor_dhost_threadpool() -> Dictionary:
    return Dictionary(
        title=Title("DHOST Threadpool"),
        elements={
            "ThreadWaitingQueuePeakItems": DictElement(
                required=False,
                parameter_form=SimpleLevels[int](
                    title=Title("ThreadWaitingQueuePeakItems"),
                    level_direction=LevelDirection.UPPER,
                    form_spec_template=Integer(),
                    migrate=migrate_to_integer_simple_levels,
                    prefill_fixed_levels=InputHint(value=(0, 5)),
                )
            ),
            "ThreadWaitingQueueItems": DictElement(
                required=False,
                parameter_form=SimpleLevels[int](
                    title=Title("ThreadWaitingQueueItems"),
                    level_direction=LevelDirection.UPPER,
                    form_spec_template=Integer(),
                    migrate=migrate_to_integer_simple_levels,
                    prefill_fixed_levels=InputHint(value=(0, 5)),
                )
            ),
            "ThreadMaxWaitTime": DictElement(
                required=False,
                parameter_form=SimpleLevels[int](
                    title=Title("Thread Max WaitTime"),
                    level_direction=LevelDirection.UPPER,
                    form_spec_template=Integer(),
                    migrate=migrate_to_integer_simple_levels,
                    prefill_fixed_levels=InputHint(value=(0, 5)),
                )
            ),
            "ThreadMinWaitTime": DictElement(
                required=False,
                parameter_form=SimpleLevels[int](
                    title=Title("Thread Min WaitTime"),
                    level_direction=LevelDirection.UPPER,
                    form_spec_template=Integer(),
                    migrate=migrate_to_integer_simple_levels,
                    prefill_fixed_levels=InputHint(value=(0, 5)),
                )
            ),
            "ThreadPoolReadyQueueMaxWaitTime": DictElement(
                required=False,
                parameter_form=SimpleLevels[int](
                    title=Title("ThreadPool ReadyQueue Max WaitTime"),
                    level_direction=LevelDirection.UPPER,
                    form_spec_template=Integer(),
                    migrate=migrate_to_integer_simple_levels,
                    prefill_fixed_levels=InputHint(value=(0, 5)),
                )
            ),
            "ThreadPoolReadyQueueItems": DictElement(
                required=False,
                parameter_form=SimpleLevels[int](
                    title=Title("ThreadPool ReadyQueue Items"),
                    level_direction=LevelDirection.UPPER,
                    form_spec_template=Integer(),
                    migrate=migrate_to_integer_simple_levels,
                    prefill_fixed_levels=InputHint(value=(0, 5)),
                )
            ),
            "ThreadPeakWorkers": DictElement(
                required=False,
                parameter_form=SimpleLevels[int](
                    title=Title("Thread Peak Workers"),
                    level_direction=LevelDirection.UPPER,
                    form_spec_template=Integer(),
                    migrate=migrate_to_integer_simple_levels,
                    prefill_fixed_levels=InputHint(value=(0, 5)),
                )
            ),
            "ThreadsWorkers": DictElement(
                required=False,
                parameter_form=SimpleLevels[int](
                    title=Title("Threads Workers"),
                    level_direction=LevelDirection.UPPER,
                    form_spec_template=Integer(),
                    migrate=migrate_to_integer_simple_levels,
                    prefill_fixed_levels=InputHint(value=(0, 5)),
                )
            ),
            "ThreadsIdle": DictElement(
                required=False,
                parameter_form=SimpleLevels[int](
                    title=Title("Threads Idle"),
                    level_direction=LevelDirection.UPPER,
                    form_spec_template=Integer(),
                    migrate=migrate_to_integer_simple_levels,
                    prefill_fixed_levels=InputHint(value=(0, 5)),
                )
            ),
            "ThreadsDied": DictElement(
                required=False,
                parameter_form=SimpleLevels[int](
                    title=Title("Threads Died"),
                    level_direction=LevelDirection.UPPER,
                    form_spec_template=Integer(),
                    migrate=migrate_to_integer_simple_levels,
                    prefill_fixed_levels=InputHint(value=(0, 5)),
                )
            ),
            "ThreadsSpawned": DictElement(
                required=False,
                parameter_form=SimpleLevels[int](
                    title=Title("Threads Spawned"),
                    level_direction=LevelDirection.UPPER,
                    form_spec_template=Integer(),
                    migrate=migrate_to_integer_simple_levels,
                    prefill_fixed_levels=InputHint(value=(0, 5)),
                )
            ),
        }
    )

def _valuespec_edirectory_monitor_dhost() -> Dictionary:
    return Dictionary(
        title=Title("DHOST Service Parameters"),
        elements={
            "dhost_inboundconnections": DictElement(
                parameter_form=_vaulespec_edirectory_monitor_dhost_inboundconnections(),
                required=False),
            "dhost_threadpool": DictElement(
                parameter_form=_vaulespec_edirectory_monitor_dhost_threadpool(),
                required=False),
        },
    )

def _item_spec() -> String:
    return String(
        help_text=Help("ServiceName")
    )

rule_spec_edirectory_monitor_dhost_params = CheckParameters(
    name="edirectory_monitor_dhost",
    title=Title("eDirectory Monitor DHOST Statistics"),
    topic=Topic.APPLICATIONS,
    condition=HostAndItemCondition(
        item_title=Title("ServiceName"), item_form=_item_spec()
        ),
    parameter_form=_valuespec_edirectory_monitor_dhost,
    create_enforced_service=False,
    )
