#!/usr/bin/env python3

# -*- encoding: utf-8; py-indent-offset: 4 -*-

# (c) Michael Honkoop <mhonkoop@comsolve.nl>

# License: GNU General Public License v2

"""parameters for eDirectory monitor Agent"""

from cmk.rulesets.v1 import Title, Help
from cmk.rulesets.v1.form_specs import (
    DictElement,
    Dictionary,
    InputHint,
    Integer,
    LevelDirection,
    migrate_to_integer_simple_levels,
    SimpleLevels,
    String,
)

from cmk.rulesets.v1.rule_specs import (
    CheckParameters,
    Topic,
    HostAndItemCondition,
)

def _vaulespec_edirectory_monitor_agent_partition() -> Dictionary:
    return Dictionary(
        title=Title("Partition Information"),
        elements={
            "PerishableData": DictElement(
                required=False,
                parameter_form=SimpleLevels[int](
                    title=Title("Perishable Data"),
                    level_direction=LevelDirection.UPPER,
                    form_spec_template=Integer(),
                    migrate=migrate_to_integer_simple_levels,
                    prefill_fixed_levels=InputHint(value=(0, 5)),
                )
            ),
            "MaxRingDelta": DictElement(
                required=False,
                parameter_form=SimpleLevels[int](
                    title=Title("Maximum Ring Delta"),
                    level_direction=LevelDirection.UPPER,
                    form_spec_template=Integer(),
                    migrate=migrate_to_integer_simple_levels,
                    prefill_fixed_levels=InputHint(value=(1800, 3601)),
                )
            ),
            "ChangeCacheCount": DictElement(
                required=False,
                parameter_form=SimpleLevels[int](
                    title=Title("Current change cache count on the partition"),
                    level_direction=LevelDirection.UPPER,
                    form_spec_template=Integer(),
                    migrate=migrate_to_integer_simple_levels,
                    prefill_fixed_levels=InputHint(value=(0, 5)),
                )
            ),
            "OBIT_COUNT_FROM_DATABASE_INDEX": DictElement(
                required=False,
                parameter_form=SimpleLevels[int](
                    title=Title("Total obituary count"),
                    level_direction=LevelDirection.UPPER,
                    form_spec_template=Integer(),
                    migrate=migrate_to_integer_simple_levels,
                    prefill_fixed_levels=InputHint(value=(0, 5)),
                )
            ),
            "OBIT_MOVED_PURGEABLE": DictElement(
                required=False,
                parameter_form=SimpleLevels[int](
                    title=Title("Number of moved obituaries in purgeable state"),
                    level_direction=LevelDirection.UPPER,
                    form_spec_template=Integer(),
                    migrate=migrate_to_integer_simple_levels,
                    prefill_fixed_levels=InputHint(value=(0, 5)),
                )
            ),
            "OBIT_MOVED_OK_TO_PURGE": DictElement(
                required=False,
                parameter_form=SimpleLevels[int](
                    title=Title("Number of moved obituaries in ok to purge state"),
                    level_direction=LevelDirection.UPPER,
                    form_spec_template=Integer(),
                    migrate=migrate_to_integer_simple_levels,
                    prefill_fixed_levels=InputHint(value=(0, 5)),
                )
            ),
            "OBIT_MOVED_NOTIFIED": DictElement(
                required=False,
                parameter_form=SimpleLevels[int](
                    title=Title("Number of moved obituaries in notified state"),
                    level_direction=LevelDirection.UPPER,
                    form_spec_template=Integer(),
                    migrate=migrate_to_integer_simple_levels,
                    prefill_fixed_levels=InputHint(value=(0, 5)),
                )
            ),
            "OBIT_MOVED_ISSUED": DictElement(
                required=False,
                parameter_form=SimpleLevels[int](
                    title=Title("Number of moved obituaries in issued state"),
                    level_direction=LevelDirection.UPPER,
                    form_spec_template=Integer(),
                    migrate=migrate_to_integer_simple_levels,
                    prefill_fixed_levels=InputHint(value=(0, 5)),
                )
            ),
            "OBIT_NEWRDN_PURGEABLE": DictElement(
                required=False,
                parameter_form=SimpleLevels[int](
                    title=Title("Number of NEWRDN obituaries in purgeable state"),
                    level_direction=LevelDirection.UPPER,
                    form_spec_template=Integer(),
                    migrate=migrate_to_integer_simple_levels,
                    prefill_fixed_levels=InputHint(value=(0, 5)),
                )
            ),
            "OBIT_NEWRDN_OK_TO_PURGE": DictElement(
                required=False,
                parameter_form=SimpleLevels[int](
                    title=Title("Number of NEWRDN obituaries in ok to purge state"),
                    level_direction=LevelDirection.UPPER,
                    form_spec_template=Integer(),
                    migrate=migrate_to_integer_simple_levels,
                    prefill_fixed_levels=InputHint(value=(0, 5)),
                )
            ),
            "OBIT_NEWRDN_NOTIFIED": DictElement(
                required=False,
                parameter_form=SimpleLevels[int](
                    title=Title("Number of NEWRDN obituaries in notified state"),
                    level_direction=LevelDirection.UPPER,
                    form_spec_template=Integer(),
                    migrate=migrate_to_integer_simple_levels,
                    prefill_fixed_levels=InputHint(value=(0, 5)),
                )
            ),
            "OBIT_NEWRDN_ISSUED": DictElement(
                required=False,
                parameter_form=SimpleLevels[int](
                    title=Title("Number of NEWRDN obituaries in issued state"),
                    level_direction=LevelDirection.UPPER,
                    form_spec_template=Integer(),
                    migrate=migrate_to_integer_simple_levels,
                    prefill_fixed_levels=InputHint(value=(0, 5)),
                )
            ),
            "OBIT_DEAD_PURGEABLE": DictElement(
                required=False,
                parameter_form=SimpleLevels[int](
                    title=Title("Number of dead obituaries in purgeable state"),
                    level_direction=LevelDirection.UPPER,
                    form_spec_template=Integer(),
                    migrate=migrate_to_integer_simple_levels,
                    prefill_fixed_levels=InputHint(value=(0, 5)),
                )
            ),
            "OBIT_DEAD_OK_TO_PURGE": DictElement(
                required=False,
                parameter_form=SimpleLevels[int](
                    title=Title("Number of dead obituaries in ok to purge state"),
                    level_direction=LevelDirection.UPPER,
                    form_spec_template=Integer(),
                    migrate=migrate_to_integer_simple_levels,
                    prefill_fixed_levels=InputHint(value=(0, 5)),
                )
            ),
            "OBIT_DEAD_NOTIFIED": DictElement(
                required=False,
                parameter_form=SimpleLevels[int](
                    title=Title("Number of dead obituaries in notified state"),
                    level_direction=LevelDirection.UPPER,
                    form_spec_template=Integer(),
                    migrate=migrate_to_integer_simple_levels,
                    prefill_fixed_levels=InputHint(value=(0, 5)),
                )
            ),
            "OBIT_DEAD_ISSUED": DictElement(
                required=False,
                parameter_form=SimpleLevels[int](
                    title=Title("Number of dead obituaries in issued state"),
                    level_direction=LevelDirection.UPPER,
                    form_spec_template=Integer(),
                    migrate=migrate_to_integer_simple_levels,
                    prefill_fixed_levels=InputHint(value=(0, 5)),
                )
            ),
        }
    )

def _valuespec_edirectory_monitor_agent() -> Dictionary:
    return Dictionary(
        title=Title("Agent Service Parameters"),
        elements={
            "agent_partition": DictElement(
                parameter_form=_vaulespec_edirectory_monitor_agent_partition(),
                required=False),
        },
    )

def _item_spec() -> String:
    return String(
        help_text=Help("ServiceName")
)

rule_spec_edirectory_monitor_agent_params = CheckParameters(
    name="edirectory_monitor_agent",
    title=Title("eDirectory Monitor Agent"),
    topic=Topic.APPLICATIONS,
    condition=HostAndItemCondition(
        item_title=Title("ServiceName"), item_form=_item_spec()
    ),
    parameter_form=_valuespec_edirectory_monitor_agent,
    create_enforced_service=False,
)
