#!/usr/bin/env python3
# -*- encoding: utf-8; py-indent-offset: 4 -*-

# (c) Michael Honkoop <mhonkoop@comsolve.nl>

# License: GNU General Public License v2

from cmk.graphing.v1 import metrics, Title
from cmk.graphing.v1.graphs import Graph

# Metrics for DHOST ThreadPool
metric_threadmaxwaittime = metrics.Metric(
    name="ThreadMaxWaitTime",
    title=Title("Maximum thread wait time before getting scheduled"),
    unit=metrics.Unit(metrics.TimeNotation()),
    color=metrics.Color.BROWN,
)

# Metric for DClient
metric_maxoutboundconnection = metrics.Metric(
    name="MaxOutBoundConnection",
    title=Title("DClient Maximum outbound connection count"),
    unit=metrics.Unit(metrics.DecimalNotation("")),
    color=metrics.Color.BROWN,
)

# Metrics for LDAP traffic
metric_inbytes = metrics.Metric(
    name="inBytes",
    title=Title("LDAP traffic bytes in"),
    unit=metrics.Unit(metrics.IECNotation("bytes")),
    color=metrics.Color.BROWN,
)

metric_outbytes = metrics.Metric(
    name="outBytes",
    title=Title("LDAP traffic bytes Out"),
    unit=metrics.Unit(metrics.IECNotation("bytes")),
    color=metrics.Color.BLUE,
)

# Combined graph of both inBytes and outBytes for LDAP Traffic
graph_ldaptraffic_combined = Graph(
    name = "ldap_traffic",
    title = Title("LDAP traffic totals"),
    compound_lines=[ "inBytes", "outBytes" ],
)

# Metric for Partition Agent
metric_maxringdelta = metrics.Metric(
    name="MaxRingDelta",
    title=Title("Maximum amount of data not synchronized between any two servers in the replica ring"),
    unit=metrics.Unit(metrics.TimeNotation()),
    color=metrics.Color.BROWN,
)

# Metrics for RecordManager Size
metric_dibfilesize = metrics.Metric(
    name="Size_DIBFileSize",
    title=Title("Total DIB files size"),
    unit=metrics.Unit(metrics.IECNotation("bytes")),
    color=metrics.Color.BROWN,
)

metric_dibflmfilesize = metrics.Metric(
    name="Size_DIBRflmFileSize",
    title=Title("Total roll forward log files size"),
    unit=metrics.Unit(metrics.IECNotation("bytes")),
    color=metrics.Color.BLUE,
)

metric_dibrollbackfilesize = metrics.Metric(
    name="Size_DIBRollBackFileSize",
    title=Title("Total roll back files size"),
    unit=metrics.Unit(metrics.IECNotation("bytes")),
    color=metrics.Color.DARK_BLUE,
)

metric_dibstreamfilesize = metrics.Metric(
    name="Size_DIBStreamFileSize",
    title=Title("Total stream files size"),
    unit=metrics.Unit(metrics.IECNotation("bytes")),
    color=metrics.Color.DARK_BROWN,
)

metric_totaldibsize = metrics.Metric(
    name="Size_TotalDIBSize",
    title=Title("Total FLAIM database size"),
    unit=metrics.Unit(metrics.IECNotation("bytes")),
    color=metrics.Color.DARK_CYAN,
)
