#!/usr/bin/env python3
"""parameters for eDirectory monitor"""

from cmk.rulesets.v1 import Title, Help
from cmk.rulesets.v1.form_specs import (
    DictElement,
    Dictionary,
    InputHint,
    Integer,
    LevelDirection,
    migrate_to_integer_simple_levels,
    SimpleLevels,
    String,
)
from cmk.rulesets.v1.rule_specs import (
    CheckParameters,
    Topic,
    HostAndItemCondition,
)


def _parameter_valuespec_windows_patch_day() -> Dictionary:
    return Dictionary(
        elements={
            "levels": DictElement(
                parameter_form=SimpleLevels[int](
                    title=Title("Generic Levels"),
                    level_direction=LevelDirection.UPPER,
                    form_spec_template=Integer(),
                    migrate=migrate_to_integer_simple_levels,
                    prefill_fixed_levels=InputHint(value=(15, 30)),
                )
            ),
        },
    )


def _item_spec() -> String:
    return String(help_text=Help("eDirectory Attribute Name"))


rule_spec_windows_patch_day = CheckParameters(
    name="edirectory_monitor",
    title=Title("eDirectory Monitor"),
    topic=Topic.OPERATING_SYSTEM,
    condition=HostAndItemCondition(
        item_title=Title("eDirectory Attribute"), item_form=_item_spec()
    ),
    parameter_form=_parameter_valuespec_windows_patch_day,
)
