#!/usr/bin/env python3

# -*- encoding: utf-8; py-indent-offset: 4 -*-

# (c) Michael Honkoop <mhonkoop@comsolve.nl>

# License: GNU General Public License v2

from collections.abc import Iterator, Mapping, Sequence

from pydantic import BaseModel

from cmk.server_side_calls.v1 import HostConfig, SpecialAgentCommand, SpecialAgentConfig
from cmk.server_side_calls.v1._utils import Secret

class Params(BaseModel):
    check_tls: bool | None = None
    user: str
    password: Secret


def commands_function(params: Params, host_config: HostConfig) -> Iterator[SpecialAgentCommand]:
    """Always use LDAPS for querying LDAP Server"""
    command_arguments: list[str | Secret] = [
        "ldaps://" +  host_config.name + ":636",
        params.user,
        params.password.unsafe(),
    ]
    if params.check_tls is not None and params.check_tls is True:
        command_arguments += ["--verify_tls"]

    yield SpecialAgentCommand(command_arguments=command_arguments)

special_agent_edirectory_monitor = SpecialAgentConfig(
    name="edirectory_monitor",
    parameter_parser=Params.model_validate,
    commands_function=commands_function,
)
